//////////////////////////////////////////////////$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
////==========================================////$                                 $
////        Upgraded By: Triple               ////$   Will like to thank for all    $
////==========================================////$   who help me with this upgrade!$
//////////////////////////////////////////////////$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

using System;
using System.Collections; 
using Server.Mobiles;
using Server.Items;
using Server.Network; 
using Server.Targeting;
using Server.Gumps;

namespace Server.Mobiles
{
	[CorpseName( "a hiryu hatchling corpse" )]
	public class EvolutionHiryu : BaseMount
	{
		
		public int m_Stage;
		public int m_KP;

		public bool m_S1;
		public bool m_S2;
		public bool m_S3;
		public bool m_S4;
		public bool m_S5;

		public bool S1
		{
			get{ return m_S1; }
			set{ m_S1 = value; }
		}
		public bool S2
		{
			get{ return m_S2; }
			set{ m_S2 = value; }
		}
		public bool S3
		{
			get{ return m_S3; }
			set{ m_S3 = value; }
		}
		public bool S4
		{
			get{ return m_S4; }
			set{ m_S4 = value; }
		}
		public bool S5
		{
			get{ return m_S5; }
			set{ m_S5 = value; }
		}		

		[CommandProperty( AccessLevel.GameMaster )]
		public int KP
		{
			get{ return m_KP; }
			set{ m_KP = value; }
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public int Stage
		{
			get{ return m_Stage; }
			set{ m_Stage = value; }
		}

		[Constructable]
		public EvolutionHiryu() : this( "a Hiryu hatchling" )
		{
		}

		[Constructable]
		public EvolutionHiryu( string name ) : base( name, 243, 0x3E94, AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a Hiryu hatchling";
			Body = 52;
			Hue = Utility.RandomList( 1157, 1175, 1172, 1171, 1170, 1169, 1168, 1167, 1166, 1165 );
			BaseSoundID = 0x4FD;
			Stage = 1;

			S1 = true;
			S2 = true;
			S3 = true;
			S4 = true;
			S5 = true;

			SetStr( 200, 250 );
			SetDex( 95, 105 );
			SetInt( 80, 100 );

			SetHits( 150, 200 );

			SetDamage( 11, 15 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 15 );

			SetSkill( SkillName.Magery, 50.1, 70.0 );
			SetSkill( SkillName.Meditation, 50.1, 70.0 );
			SetSkill( SkillName.EvalInt, 50.1, 70.0 );
			SetSkill( SkillName.MagicResist, 15.1, 20.0 );
			SetSkill( SkillName.Tactics, 19.3, 34.0 );
			SetSkill( SkillName.Wrestling, 19.3, 34.0 );
			SetSkill( SkillName.Anatomy, 19.3, 34.0 );

			Fame = 30000;
			Karma = -3000;

			VirtualArmor = 30;

			ControlSlots = 2;

			PackItem( new HiryuDust( 20 ) );
			

		}

		public EvolutionHiryu(Serial serial) : base(serial)
		{
		}
		
		public override void Damage( int amount, Mobile defender )
		
		{

			int kpgainmin, kpgainmax;

			if ( this.Stage == 1 )
			{
				if ( defender is BaseCreature )
				{
					BaseCreature bc = (BaseCreature)defender;

					if ( bc.Controlled != true )
					{
						kpgainmin = 5 + ( bc.HitsMax ) / 10;
						kpgainmax = 5 + ( bc.HitsMax ) / 5;

						this.KP += Utility.RandomList( kpgainmin, kpgainmax );
					}
				}

				if ( this.KP >= 25000 )
				{
					if ( this.S1 == true )
					{
						this.S1 = false;
						int hits, va, mindamage, maxdamage;

						hits = ( this.HitsMax + 450 );

						va = ( this.VirtualArmor + 10 );

						mindamage = this.DamageMin + ( 2 );
						maxdamage = this.DamageMax + ( 2 );

						this.Warmode = false;
						this.Say( "*"+ this.Name +" evolves*");
						this.SetDamage( mindamage, maxdamage );
						this.SetHits( hits );
						this.BodyValue = 6;
						this.BaseSoundID = 0x4FD;
						this.VirtualArmor = va;
						this.Stage = 2;

						this.SetDamageType( ResistanceType.Physical, 20 );
						this.SetDamageType( ResistanceType.Fire, 20 );
						this.SetDamageType( ResistanceType.Cold, 20 );
						this.SetDamageType( ResistanceType.Poison, 20 );
						this.SetDamageType( ResistanceType.Energy, 20 );

						this.SetResistance( ResistanceType.Physical, 25 );
						this.SetResistance( ResistanceType.Fire, 25 );
						this.SetResistance( ResistanceType.Cold, 25 );
						this.SetResistance( ResistanceType.Poison, 25 );
						this.SetResistance( ResistanceType.Energy, 25 );

						this.RawStr += 150;
						this.RawInt += 50;
						this.RawDex += 40;
					}
				}
			}

			else if ( this.Stage == 2 )
			{
				if ( defender is BaseCreature )
				{
					BaseCreature bc = (BaseCreature)defender;

					if ( bc.Controlled != true )
					{
						kpgainmin = 5 + ( bc.HitsMax ) / 30;
						kpgainmax = 5 + ( bc.HitsMax ) / 20;

						this.KP += Utility.RandomList( kpgainmin, kpgainmax );
					}
				}

				if ( this.KP >= 75000 )
				{
					if ( this.S2 == true )
					{
						this.S2 = false;
						int hits, va, mindamage, maxdamage;

						hits = ( this.HitsMax + 100 );

						va = ( this.VirtualArmor + 20 );

						mindamage = this.DamageMin + ( 5 );
						maxdamage = this.DamageMax + ( 5 );

						this.Warmode = false;
						this.Say( "*"+ this.Name +" evolves*");
						this.SetDamage( mindamage, maxdamage );
						this.SetHits( hits );
						this.BodyValue = 5;
						this.BaseSoundID = 0x4FD;
						this.VirtualArmor = va;
						this.Stage = 3;

						this.SetDamageType( ResistanceType.Physical, 100 );
						this.SetDamageType( ResistanceType.Fire, 20 );
						this.SetDamageType( ResistanceType.Cold, 20 );
						this.SetDamageType( ResistanceType.Poison, 20 );
						this.SetDamageType( ResistanceType.Energy, 20 );

						this.SetResistance( ResistanceType.Physical, 35 );
						this.SetResistance( ResistanceType.Fire, 35 );
						this.SetResistance( ResistanceType.Cold, 35 );
						this.SetResistance( ResistanceType.Poison, 35 );
						this.SetResistance( ResistanceType.Energy, 35 );

						this.RawStr += 100;
						this.RawInt += 40;
						this.RawDex += 40;
					}
				}
			}

			else if ( this.Stage == 3 )
			{
				if ( defender is BaseCreature )
				{
					BaseCreature bc = (BaseCreature)defender;

					if ( bc.Controlled != true )
					{
						kpgainmin = 5 + ( bc.HitsMax ) / 100;
						kpgainmax = 5 + ( bc.HitsMax ) / 80;

						this.KP += Utility.RandomList( kpgainmin, kpgainmax );
					}
				}

				if ( this.KP >= 1250000 )
				{
					if ( this.S3 == true )
					{
						this.S3 = false;
						int hits, va, mindamage, maxdamage;

						hits = ( this.HitsMax + 100 );

						va = ( this.VirtualArmor + 10 );

						mindamage = this.DamageMin + ( 5 );
						maxdamage = this.DamageMax + ( 5 );

						this.Warmode = false;
						this.Say( "*"+ this.Name +" evolves*");
						this.SetDamage( mindamage, maxdamage );
						this.SetHits( hits );
						this.BodyValue = 254;
						this.BaseSoundID = 0x4FD;
						this.VirtualArmor = va;
						this.Stage = 4;

						this.SetResistance( ResistanceType.Physical, 40 );
						this.SetResistance( ResistanceType.Fire, 40 );
						this.SetResistance( ResistanceType.Cold, 40 );
						this.SetResistance( ResistanceType.Poison, 40 );
						this.SetResistance( ResistanceType.Energy, 40 );

						this.RawStr += 150;
						this.RawInt += 100;
						this.RawDex += 40;
					}
				}
			}

			else if ( this.Stage == 4 )
			{
				if ( defender is BaseCreature )
				{
					BaseCreature bc = (BaseCreature)defender;

					if ( bc.Controlled != true )
					{
						kpgainmin = 5 + ( bc.HitsMax ) / 540;
						kpgainmax = 5 + ( bc.HitsMax ) / 480;

						this.KP += Utility.RandomList( kpgainmin, kpgainmax );
					}
				}

				if ( this.KP >= 7750000 )
				{
					if ( this.S4 == true )
					{
						this.S4 = false;
						int hits, va, mindamage, maxdamage;

						hits = ( this.HitsMax + 300 );

						va = ( this.VirtualArmor + 100 );

						mindamage = this.DamageMin + ( 10 );
						maxdamage = this.DamageMax + ( 10 );

						this.Warmode = false;
						this.Say( "*"+ this.Name +" is now an Ancient Hiryu*");
						this.Title = "the Ancient Hiryu";
						this.SetDamage( mindamage, maxdamage );
						this.SetHits( hits );
						this.BodyValue = 0xF3;
						this.BaseSoundID = 0x4FD;
						this.VirtualArmor = va;
						this.Stage = 5;

						this.SetDamageType( ResistanceType.Physical, 100 );
						this.SetDamageType( ResistanceType.Fire, 40 );
						this.SetDamageType( ResistanceType.Cold, 40 );
						this.SetDamageType( ResistanceType.Poison, 40 );
						this.SetDamageType( ResistanceType.Energy, 40 );
						
						SetResistance( ResistanceType.Physical, 90 );
						SetResistance( ResistanceType.Fire, 90 );
						SetResistance( ResistanceType.Cold, 90 );
						SetResistance( ResistanceType.Poison, 90 );
						SetResistance( ResistanceType.Energy, 90 );


						this.RawStr += 200;
						this.RawInt += 200;
						this.RawDex += 60;
					

					}
				}
			}
			base.Damage( amount, defender );
		}

		public override bool OnDragDrop( Mobile from, Item dropped )
   		{
   			PlayerMobile player = from as PlayerMobile;
   
   			if ( player != null )
   			{
   				if ( dropped is HiryuDust )
   				{
 		 		HiryuDust dust = ( HiryuDust )dropped;
   
 					int amount = ( dust.Amount * 20 );
   
 					this.PlaySound( 665 );
 					this.KP += amount;
 					dust.Delete();
 		 		this.Say( "*"+ this.Name +" absorbs the Hiryu dust*" );
   
 					return false;
   				}
   				else
   				{
   				}
   			}
   			return base.OnDragDrop( from, dropped );
   		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 1);			
			writer.Write( m_S1 );
                        writer.Write( m_S2 ); 
                        writer.Write( m_S3 ); 
                        writer.Write( m_S4 ); 
                        writer.Write( m_S5 );  
			writer.Write( (int) m_KP );
			writer.Write( (int) m_Stage );
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();

			switch ( version )
			{
				case 1:
				{
                        		m_S1 = reader.ReadBool(); 
                        		m_S2 = reader.ReadBool(); 
                        		m_S3 = reader.ReadBool(); 
                        		m_S4 = reader.ReadBool(); 
                        		m_S5 = reader.ReadBool(); 
					m_KP = reader.ReadInt();
					m_Stage = reader.ReadInt();

					break;
				}
			}
		}
	}
}